// SquareWaveDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SquareWave.h"
#include "SquareWaveDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSquareWaveDlg dialog

CSquareWaveDlg::CSquareWaveDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSquareWaveDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSquareWaveDlg)
	m_freq = 0;
	m_errMsg = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSquareWaveDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSquareWaveDlg)
	DDX_Control(pDX, IDC_STATIC1, m_logo);
	DDX_Control(pDX, IDC_Stop, m_Stop);
	DDX_Control(pDX, IDC_Start, m_Start);
	DDX_Text(pDX, IDC_Freq, m_freq);
	DDV_MinMaxUInt(pDX, m_freq, 77, 50000);
	DDX_Text(pDX, IDC_ERROR_MSG, m_errMsg);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSquareWaveDlg, CDialog)
	//{{AFX_MSG_MAP(CSquareWaveDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_OpenDriver, OnOpenDriver)
	ON_BN_CLICKED(IDC_Start, OnStart)
	ON_BN_CLICKED(IDC_Stop, OnStop)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSquareWaveDlg message handlers

BOOL CSquareWaveDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_pSR=NULL;
    m_driverInstance=NULL;
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSquareWaveDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSquareWaveDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSquareWaveDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSquareWaveDlg::OnOpenDriver() 
{

	   // Open the driver and Initialize the hardware

// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance=OpenDriverLINX(m_hWnd,"kpci3108"); //Open DriverLINX driver, and bring up the dialog box to pick a driver
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member

m_pSR->device=0; //set the device number (DriverLINX Config Panel setting)
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application
//Execute the initialize service
 //show any errors	

if (DriverLINX(m_pSR) == NoErr)
{
	// success
m_Start.EnableWindow(TRUE);  // enable the Sample button
m_freq = 1000;
UpdateData(FALSE);
}
else
{  // problem has occured
showMessage(m_pSR);  // display the error message box

}

// set focus back to our dialog
CWnd::SetActiveWindow();	
}

void CSquareWaveDlg::OnStart() 
{
/*	

  This program was tested in Windows 2000 SP1, 3108-850A04.0.0.1 DriverLINX
  Microsoft VC++ 6.0 Standard Edition

  Look for square wave output at pin 6 of STP-36.  In DriverLINX Config Panel, 
  the Special button, the OP0...OP4 must be set to 'SSH & CLKOUT' in order to
  be able to get the outputs from the counter chip routed to the external world.
  Reboot if necessary for this setting to take effect.

  KPCI-3108 uses a 10MHz timebase, but this can be divided down to slower
  values.  The value of the Internal1 timebase is controlled by the 
  DriverLINX Configuration Panel (5MHz default).  Other timebases available are:
  Internal2 = 10MHz
  Internal3 =  5MHz
  Internal4 =  1MHz
  Internal5 =  100 KHz

  Slowest Freq that can be generated with one 16-bit counter is timebase/65535.

  Will get 'clock rate too fast for hardware error' if you try to go slower than this.



*/

// get the requested rate
float freqRate;
UpdateData(TRUE);
freqRate = (float) 1/m_freq;  // compute period from the requested Freq
// setup the DriverLINX task
m_pSR->operation=START;  // start operation
m_pSR->subsystem=CT;     // using CT subsystem
m_pSR->mode=POLLED;      // no timing info required.....POLLED mode
m_pSR->start.typeEvent=COMMAND;   // start when we call DriverLINX function
m_pSR->timing.typeEvent=RATEEVENT;  // speed of the task will be specified
m_pSR->stop.typeEvent=COMMAND;  // stop type
m_pSR->timing.u.rateEvent.channel=1;   // use channel 1 of CT subsystem
// witnesss signal at pin 6, OP1.  Remember, the output must be configured
// in DLINX Config Panel for CT outputs (rather than default role of digital outputs)

m_pSR->timing.u.rateEvent.mode=SQWAVE;  // generate Square Wave
m_pSR->timing.u.rateEvent.pulses=0;     // not used
m_pSR->timing.u.rateEvent.clock=INTERNAL1;  // usually 5MHz timebase; Config Panel dependent
m_pSR->timing.u.rateEvent.period=Sec2Tics(0,CT,INTERNAL1,freqRate); // let it compute
//  the number of tics of the selected time base to achieve our requested period
m_pSR->timing.u.rateEvent.onCount=0;  // not used
m_pSR->timing.u.rateEvent.gate=NOCONNECT;  // gating not used in this example
if (DriverLINX(m_pSR) == NoErr)  // start the task by calling DriverLINX function
{
	// success
m_Stop.EnableWindow(TRUE);  // enable the Stop button
m_Start.EnableWindow(FALSE);  // disable the Start button
}
else
{  // problem has occured
showMessage(m_pSR);  // display the error message box
}


}

void CSquareWaveDlg::OnStop() 
{
		// TO DO: add better logic here
/*
  if we do a STOP operation on a task that does not exist, an error will result.
  this app does not do any error checking for this condition.
*/
m_pSR->operation=STOP;	
DriverLINX(m_pSR);
//  would be "active task not found" error if no active task existed
//  But it does not kill us.
m_Stop.EnableWindow(FALSE);  // disable the Stop button
m_Start.EnableWindow(TRUE);  // enable the Start button
}

void CSquareWaveDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
/*
// the code below could be used instead of the messagebox operation above

char errString[100];
DWORD size=50;
int errNumber;
errNumber = getErrCode(SR->result);
// errNumber corresponds to DriverLINX documentation
ReturnMessageString(SR->hWnd,SR->result,errString,size);
// errString corresponds to DriverLINX documentation
m_errMsg.Format("%s",errString);
UpdateData(FALSE);  // update the dialog
*/

	return;
}

void CSquareWaveDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
// code to clean up after DriverLINX
if (m_driverInstance != NULL)
{
   CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
   m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
}
if (m_pSR != NULL)
{

   delete(m_pSR); //de-allocate the memory used by the service request
   m_pSR=NULL;
}
	
	CDialog::OnClose();
}
